import java.util.*;

import gov.nih.nlm.nls.lvg.Api.*;

public class Normalization
{
	// test driver
	public static void main(String[] args)
	{
		// instantiate a LvgApi object by config file
		String lvgConfigFile
			= "/export/home/lu/Projects/LVG/lvg2012/data/config/lvg.properties";
		NormApi normApi = new NormApi(lvgConfigFile);

		// Process the inflectional variants mutation
		String in = "left";	// use lexItem as input to lvgApi
		try
		{
			Vector<String> outs = normApi.Mutate(in);

			// PrintOut the Result
			for(String out: outs)
			{
				System.out.println(in + "|" + out);
			}

			// clean up
			normApi.CleanUp();
		}
		catch (Exception e)
		{
			System.err.println("** ERR: " + e.toString());
		}
	}
}
